/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.SkinsRestorerAPI;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.ISRCommandSender;
import net.skinsrestorer.api.interfaces.ISRPlayer;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.aikar.commands.CommandHelp;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.InvalidCommandArgument;
import net.skinsrestorer.shared.commands.CommandUtil;
import net.skinsrestorer.shared.interfaces.ISRPlugin;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.CooldownStorage;
import net.skinsrestorer.shared.storage.Locale;
import net.skinsrestorer.shared.utils.C;

public interface ISkinCommand {
    public static final IProperty emptySkin = SkinsRestorerAPI.getApi().createPlatformProperty("textures", "", "");

    default public void onDefault(ISRCommandSender sender) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        this.onHelp(sender, CommandManager.getCurrentCommandManager().generateCommandHelp());
    }

    default public void onSkinSetShort(ISRPlayer player, String skin) {
        if (!CommandUtil.isAllowedToExecute(player)) {
            return;
        }
        this.onSkinSetOther(player, player, skin, null);
    }

    default public void onHelp(ISRCommandSender sender, CommandHelp help) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        if (Config.ENABLE_CUSTOM_HELP) {
            this.sendHelp(sender);
        } else {
            help.showHelp();
        }
    }

    default public void onSkinClear(ISRPlayer player) {
        if (!CommandUtil.isAllowedToExecute(player)) {
            return;
        }
        this.onSkinClearOther(player, player);
    }

    default public void onSkinClearOther(ISRCommandSender sender, ISRPlayer target) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            String sName = sender.getName();
            if (!sender.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(sName)) {
                sender.sendMessage(String.format(Locale.SKIN_COOLDOWN, CooldownStorage.getCooldown(sName)));
                return;
            }
            String pName = target.getName();
            String skin = this.getPlugin().getSkinStorage().getDefaultSkinName(pName, true);
            plugin.getSkinStorage().removeSkinOfPlayer(pName);
            if (this.setSkin(sender, target, skin, false, true, null)) {
                if (sender == target) {
                    sender.sendMessage(Locale.SKIN_CLEAR_SUCCESS);
                } else {
                    sender.sendMessage(Locale.SKIN_CLEAR_ISSUER.replace("%player", pName));
                }
            }
        });
    }

    default public void onSkinSearch(ISRCommandSender sender, String searchString) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        sender.sendMessage(Locale.SKIN_SEARCH_MESSAGE.replace("%SearchString%", searchString));
    }

    default public void onSkinUpdate(ISRPlayer player) {
        if (!CommandUtil.isAllowedToExecute(player)) {
            return;
        }
        this.onSkinUpdateOther(player, player);
    }

    default public void onSkinUpdateOther(ISRCommandSender sender, ISRPlayer player) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            String sName = sender.getName();
            if (!sender.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(sName)) {
                sender.sendMessage(String.format(Locale.SKIN_COOLDOWN, CooldownStorage.getCooldown(sName)));
                return;
            }
            String pName = player.getName();
            Optional<String> skin = plugin.getSkinStorage().getSkinOfPlayer(pName);
            try {
                if (skin.isPresent()) {
                    if (skin.get().startsWith(" ")) {
                        sender.sendMessage(Locale.ERROR_UPDATING_URL);
                        return;
                    }
                    if (!plugin.getSkinStorage().updateSkinData(skin.get())) {
                        sender.sendMessage(Locale.ERROR_UPDATING_SKIN);
                        return;
                    }
                } else {
                    skin = Optional.of(plugin.getSkinStorage().getDefaultSkinName(pName, true));
                }
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
                return;
            }
            if (this.setSkin(sender, player, skin.get(), false, false, null)) {
                if (sender == player) {
                    sender.sendMessage(Locale.SUCCESS_UPDATING_SKIN);
                } else {
                    sender.sendMessage(Locale.SUCCESS_UPDATING_SKIN_OTHER.replace("%player", pName));
                }
            }
        });
    }

    default public void onSkinSet(ISRPlayer player, String[] skin) {
        if (!CommandUtil.isAllowedToExecute(player)) {
            return;
        }
        if (skin.length == 0) {
            throw new InvalidCommandArgument(true);
        }
        this.onSkinSetOther(player, player, skin[0], null);
    }

    default public void onSkinSetOther(ISRCommandSender sender, ISRPlayer player, String skin, SkinVariant skinVariant) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        ISRPlugin plugin = this.getPlugin();
        plugin.runAsync(() -> {
            if (!(!Config.PER_SKIN_PERMISSIONS || sender.hasPermission("skinsrestorer.skin." + skin) || sender.hasPermission("skinsrestorer.ownskin") || sender.equalsPlayer(player) && skin.equalsIgnoreCase(sender.getName()))) {
                sender.sendMessage(Locale.PLAYER_HAS_NO_PERMISSION_SKIN);
                return;
            }
            if (this.setSkin(sender, player, skin, true, false, skinVariant) && !sender.equalsPlayer(player)) {
                sender.sendMessage(Locale.ADMIN_SET_SKIN.replace("%player", player.getName()));
            }
        });
    }

    default public void onSkinSetUrl(ISRPlayer player, String url, SkinVariant skinVariant) {
        if (!CommandUtil.isAllowedToExecute(player)) {
            return;
        }
        if (!C.validUrl(url)) {
            player.sendMessage(Locale.ERROR_INVALID_URLSKIN);
            return;
        }
        this.onSkinSetOther(player, player, url, skinVariant);
    }

    default public void sendHelp(ISRCommandSender sender) {
        if (!CommandUtil.isAllowedToExecute(sender)) {
            return;
        }
        if (!Locale.SR_LINE.isEmpty()) {
            sender.sendMessage(Locale.SR_LINE);
        }
        sender.sendMessage(Locale.CUSTOM_HELP_IF_ENABLED.replace("%ver%", this.getPlugin().getVersion()));
        if (!Locale.SR_LINE.isEmpty()) {
            sender.sendMessage(Locale.SR_LINE);
        }
    }

    default public boolean setSkin(ISRCommandSender sender, ISRPlayer player, String skin, boolean save, boolean clear, SkinVariant skinVariant) {
        ISRPlugin plugin = this.getPlugin();
        if (skin.equalsIgnoreCase("null")) {
            sender.sendMessage(Locale.INVALID_PLAYER.replace("%player", skin));
            return false;
        }
        if (Config.DISABLED_SKINS_ENABLED && !clear && !sender.hasPermission("skinsrestorer.bypassdisabled")) {
            if (Config.DISABLED_SKINS.stream().anyMatch(skin::equalsIgnoreCase)) {
                sender.sendMessage(Locale.SKIN_DISABLED);
                return false;
            }
        }
        String senderName = sender.getName();
        if (!sender.hasPermission("skinsrestorer.bypasscooldown") && CooldownStorage.hasCooldown(senderName)) {
            sender.sendMessage(Locale.SKIN_COOLDOWN.replace("%s", String.valueOf(CooldownStorage.getCooldown(senderName))));
            return false;
        }
        String playerName = player.getName();
        Optional<String> oldSkinName = plugin.getSkinStorage().getSkinOfPlayer(playerName);
        if (C.validUrl(skin)) {
            if (!(sender.hasPermission("skinsrestorer.command.set.url") || Config.SKIN_WITHOUT_PERM || clear)) {
                sender.sendMessage(Locale.PLAYER_HAS_NO_PERMISSION_URL);
                return false;
            }
            if (!C.allowedSkinUrl(skin)) {
                sender.sendMessage(Locale.SKINURL_DISALLOWED);
                return false;
            }
            CooldownStorage.setCooldown(senderName, Config.SKIN_CHANGE_COOLDOWN, TimeUnit.SECONDS);
            try {
                sender.sendMessage(Locale.MS_UPDATING_SKIN);
                String skinEntry = " " + playerName;
                if (skinEntry.length() > 16) {
                    skinEntry = skinEntry.substring(0, 16);
                }
                IProperty generatedSkin = SkinsRestorerAPI.getApi().genSkinUrl(skin, skinVariant);
                plugin.getSkinStorage().setSkinData(skinEntry, generatedSkin, System.currentTimeMillis() + 3153600000000L);
                plugin.getSkinStorage().setSkinOfPlayer(playerName, skinEntry);
                SkinsRestorerAPI.getApi().applySkin(player.getWrapper(), generatedSkin);
                if (!Locale.SKIN_CHANGE_SUCCESS.isEmpty() && !Locale.SKIN_CHANGE_SUCCESS.equals(Locale.PREFIX)) {
                    player.sendMessage(Locale.SKIN_CHANGE_SUCCESS.replace("%skin", "skinUrl"));
                }
                return true;
            }
            catch (SkinRequestException e) {
                sender.sendMessage(e.getMessage());
            }
            catch (Exception e) {
                plugin.getSrLogger().debug("[ERROR] Exception: could not generate skin url:" + skin + "\nReason= " + e.getMessage());
                sender.sendMessage(Locale.ERROR_INVALID_URLSKIN);
            }
        } else {
            CooldownStorage.setCooldown(senderName, Config.SKIN_CHANGE_COOLDOWN, TimeUnit.SECONDS);
            try {
                if (save) {
                    plugin.getSkinStorage().setSkinOfPlayer(playerName, skin);
                }
                SkinsRestorerAPI.getApi().applySkin(player.getWrapper(), skin);
                if (!Locale.SKIN_CHANGE_SUCCESS.isEmpty() && !Locale.SKIN_CHANGE_SUCCESS.equals(Locale.PREFIX)) {
                    player.sendMessage(Locale.SKIN_CHANGE_SUCCESS.replace("%skin", skin));
                }
                return true;
            }
            catch (SkinRequestException e) {
                if (clear) {
                    SkinsRestorerAPI.getApi().applySkin(player.getWrapper(), emptySkin);
                    return true;
                }
                sender.sendMessage(e.getMessage());
            }
        }
        CooldownStorage.setCooldown(senderName, Config.SKIN_ERROR_COOLDOWN, TimeUnit.SECONDS);
        this.rollback(playerName, oldSkinName.orElse(playerName), save);
        return false;
    }

    default public void rollback(String pName, String oldSkinName, boolean save) {
        if (save) {
            this.getPlugin().getSkinStorage().setSkinOfPlayer(pName, oldSkinName);
        }
    }

    public ISRPlugin getPlugin();
}

